/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWException;
import filenet.vw.api.VWFetchType;
import filenet.vw.api.VWPersistentCollection;
import filenet.vw.api.VWRosterDefinition;
import filenet.vw.api.VWRosterQuery;
import filenet.vw.api.VWRosterStats;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWTimeUnitType;
import filenet.vw.server.VWCommandSession;
import filenet.vw.server.VWField;
import java.io.Serializable;
import java.util.Date;

public final class VWRoster
extends VWPersistentCollection
implements Serializable {
    private static final long serialVersionUID = 7555L;
    public static final int QUERY_NO_OPTIONS = 0;
    public static final int QUERY_READ_UNWRITABLE = 4;
    public static final int QUERY_MIN_VALUES_INCLUSIVE = 32;
    public static final int QUERY_MAX_VALUES_INCLUSIVE = 64;
    public static final int QUERY_GET_SYSTEM_FIELDS = 256;
    public static final int QUERY_GET_TRANSLATED_SYSTEM_FIELDS = 512;
    public static final int QUERY_GET_NO_SYSTEM_FIELDS = 1024;
    public static final int QUERY_GET_NO_TRANSLATED_SYSTEM_FIELDS = 2048;
    public static final int QUERY_RESOLVE_NAMES = 8192;
    public static final int QUERY_SORT_DESCENDING_ENABLED = 16384;
    protected String FWobTag = "F_WobTag";
    VWField[] fields = null;
    protected int bufferSize = 50;

    public static String _get_FILE_DATE() {
        return "$Date: 2010-08-05 22:00:35 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Van Vuong;5D6184897;vanvuong1@us.ibm.com (vvuong) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_452_Int/PUI_460_Int/7 $";
    }

    protected VWRoster(String name, VWSession serviceSession) throws VWException {
        super(name, serviceSession);
    }

    public int getCount() throws VWException {
        return this.fetchCount();
    }

    public int fetchCount() throws VWException {
        return this.cmdSession.getRosterCount(this.viewId);
    }

    public synchronized VWRosterQuery startQuery(String indexName, Object[] minValues, Object[] maxValues, int queryFlags, String filter, Object[] substitutionVars) throws VWException {
        return new VWRosterQuery(this, indexName, minValues, maxValues, queryFlags, filter, substitutionVars, 1);
    }

    public VWRosterQuery createQuery(String indexName, Object[] firstValues, Object[] lastValues, int queryFlags, String filter, Object[] substitutionVars, int fetchType) throws VWException {
        if (!VWFetchType.isValid(fetchType)) {
            throw new VWException("vw.api.RInvalidFetchType", "Invalid fetch type {0}.", new Integer(fetchType));
        }
        if (fetchType != 1 && fetchType != 5 && fetchType != 4) {
            throw new VWException("vw.api.RInvalidFetchTypeForRoster", "Invalid fetch type {0} for VWRoster.", new Integer(fetchType));
        }
        return new VWRosterQuery(this, this.authorStr(indexName), firstValues, lastValues, queryFlags, filter, substitutionVars, 1, this.bufferSize, fetchType);
    }

    protected String getDestination(String serviceName, int isolatedRegion) {
        return VWCommandSession.rosterDestination(serviceName, isolatedRegion, this.name);
    }

    protected VWField[] getNonSystemFields() {
        return null;
    }

    public VWSession getServiceSession() {
        return this.serviceSession;
    }

    public VWRosterStats fetchStatistics(Date startTime, Date endTime, int timeUnits) throws VWException {
        if (!VWTimeUnitType.isValid(timeUnits)) {
            throw new VWException("vw.api.RInvalidTimeUnitType", "Invalid time unit type.");
        }
        VWRosterStats result = this.cmdSession.getRosterStatistics(this.viewId, startTime, endTime, timeUnits);
        result.setSession(this.cmdSession);
        return result;
    }

    public String toString() {
        return this.getName();
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int newSize) throws VWException {
        if (newSize < 1) {
            throw new VWException("vw.api.RBufferSizeInvalid", "Buffer size specified to fetch is not valid.");
        }
        this.bufferSize = newSize;
    }

    public VWRosterDefinition fetchRosterDefinition() throws VWException {
        VWRosterDefinition rosterDef = this.cmdSession.getRosterDefinition(this.getAuthoredName());
        rosterDef.setSession(this.getSession());
        return rosterDef;
    }

    protected boolean deleteInjectSession(String sessionName) throws VWException {
        return this.cmdSession.deleteInjectSession(this.getAuthoredName(), sessionName);
    }
}

